<?php

Yii::import('ext.yiiexcel.YiiExcel', true);
YiiExcel::init();

class ImageReader
{
	/* @var $handle ZipArchive */
	private $handle;
	/* @var $DRAWINGS array */
	private $DRAWINGS = array();

	const IMAGES_PATH = 'uploads/zlecenia';

	public function fetchFromZip($state)
	{
		$zip = Yii::app()->user->getState($state);
		if (is_array($zip))
		{
			$this->handle = new ZipArchive;
			$res = $this->handle->open($zip['file']);
			if ($res !== true)
				$this->handle = null;
		}
	}

	public function fetchFromSpreadSheet($sheet, $readFilter)
	{
		$drawings = $sheet->getDrawingCollection();
		$this->DRAWINGS = array();
		foreach ($drawings as $drawing)
		{
			$cords = $drawing->getCoordinates();
			$cordsArr = preg_split('/([A-Z]{1,})([0-9]{1,})/', $cords, -1, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);
			$rowNum = (int)$cordsArr[1];
			if ($rowNum > 1 && $readFilter->rowAllowed($rowNum))
				$this->DRAWINGS[$rowNum] = $drawing;
		}
	}

	private function generateFileName($ext)
	{
		if (!file_exists(self::IMAGES_PATH))
			mkdir(self::IMAGES_PATH, 0777, true);
		do
			$fileName = self::IMAGES_PATH . '/'.md5(uniqid()).'.'.$ext;
		while (file_exists($fileName));
		return $fileName;
	}

	private function tryStoreFromDrawings($rowNum)
	{
		if (isset($this->DRAWINGS[$rowNum]))
		{
			$drawing = $this->DRAWINGS[$rowNum];
			if ($drawing instanceof PHPExcel_Worksheet_MemoryDrawing)
			{
				ob_start();
				call_user_func(
					$drawing->getRenderingFunction(),
					$drawing->getImageResource()
				);
				$imageContents = ob_get_contents();
				ob_end_clean();
				switch ($drawing->getMimeType())
				{
					case PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_PNG :
						$extension = 'png';
						break;
					case PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_GIF:
						$extension = 'gif';
						break;
					case PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_JPEG :
						$extension = 'jpg';
						break;
				}
			}
			else
			{
				$zipReader = fopen($drawing->getPath(), 'r');
				$imageContents = '';
				while (!feof($zipReader))
					$imageContents .= fread($zipReader, 1024);
				fclose($zipReader);
				$extension = $drawing->getExtension();
			}
			$fileName = $this->generateFileName($extension);
			if (file_put_contents($fileName, $imageContents) !== false)
				return $fileName;
		}
		return null;
	}

	private function getFileHandle($lp)
	{
		if (empty($this->handle))
			return array(false, null);
		foreach (array('png', 'jpg', 'jpeg', 'png') as $ext)
		{
			$index = $this->handle->locateName($lp.'.'.$ext, ZipArchive::FL_NOCASE | ZipArchive::FL_NODIR);
			if ($index !== false)
				return array($index, $ext);
		}
		return array(false, null);
	}

	private function tryStoreFromZip($lp)
	{
		list($index, $ext) = $this->getFileHandle($lp);
		if ($index === false) return null;

		$content = $this->handle->getFromIndex($index);

		$fileName = $this->generateFileName($ext);

		if (file_put_contents($fileName, $content) === false)
			return null;
		else
			return $fileName;
	}

	public function storeImage($lp, $rowNum)
	{
		$path = $this->tryStoreFromDrawings($rowNum);
		if (empty($path))
			$path = $this->tryStoreFromZip($lp);
		return $path;
	}

	public function close()
	{
		if ($this->handle)
			$this->handle->close();
		unset($this->DRAWINGS);
		$this->DRAWINGS = array();
		$this->handle = null;
	}
}
